using ConnectorLib.JSON;
using Rewired;

namespace CrowdControl.Delegates.Effects.Implementations
{
    [Effect(new[]{"invert_movement", "invert_aim"}, 30)]
    public class Controls : Effect
    {
        public Controls(CrowdControl mod, NetworkClient client) : base(mod, client) { }

        public void InvertAxis(Player rewiredPlayer, bool invert)
        {
            // Joysticks
            for (int i = 0; i < rewiredPlayer.controllers.joystickCount; i++)
            {
                foreach (ControllerMap cMap in rewiredPlayer.controllers.maps.GetMaps(ControllerType.Joystick, rewiredPlayer.controllers.Joysticks[i].id))
                {
                    foreach (ActionElementMap aem in cMap.ElementMaps)
                    {
                        if (aem.axisType == AxisType.None) continue;
                        aem.invert = invert;
                    }
                }
            }
            // Keyboard
            foreach (ControllerMap cMap in rewiredPlayer.controllers.maps.GetMaps(ControllerType.Keyboard, rewiredPlayer.controllers.Keyboard.id))
            {
                foreach (ActionElementMap aem in cMap.ElementMaps)
                {
                    if (aem.axisType == AxisType.None) continue;
                    aem.invert = invert;
                }
            }

            // Mouse
            foreach (ControllerMap cMap in rewiredPlayer.controllers.maps.GetMaps(ControllerType.Mouse, rewiredPlayer.controllers.Mouse.id))
            {
                foreach (ActionElementMap aem in cMap.ElementMaps)
                {
                    if (aem.axisType == AxisType.None) continue;
                    aem.invert = invert;
                }
            }
        }
        
        public override EffectResponse Start(EffectRequest request)
        {
            PlayerController player = Manager.main.player;
            if (player == null) return EffectResponse.Failure(request.ID, StandardErrors.PlayerNotFound);

            PlayerInput input = player.inputModule;
            if (input == null) return EffectResponse.Failure(request.ID, StandardErrors.GameObjectNotFound, "Player input module not found.");
            
            Player rewiredPlayer = input.rewiredPlayer;
            if (rewiredPlayer == null) return EffectResponse.Failure(request.ID, StandardErrors.GameObjectNotFound, "Rewired player object not found.");
            
            switch (request.code)
            {
                case "invert_movement":
                    InvertAxis(rewiredPlayer, true);
                    return EffectResponse.Success(request.ID);
                case "invert_aim":
                    InvertAxis(rewiredPlayer, true);
                    return EffectResponse.Success(request.ID);
                default:
                    return EffectResponse.Failure(request.ID, StandardErrors.EffectUnknown);
            }
        }

        public override EffectResponse Pause(EffectRequest request) => Stop(request);

        public override EffectResponse Resume(EffectRequest request)
        {
            PlayerController player = Manager.main.player;
            if (player == null) return EffectResponse.Failure(request.ID, StandardErrors.PlayerNotFound);

            PlayerInput input = player.inputModule;
            if (input == null) return EffectResponse.Failure(request.ID, StandardErrors.GameObjectNotFound, "Player input module not found.");

            Player rewiredPlayer = input.rewiredPlayer;
            if (rewiredPlayer == null) return EffectResponse.Failure(request.ID, StandardErrors.GameObjectNotFound, "Rewired player object not found.");

            switch (request.code)
            {
                case "invert_movement":
                    InvertAxis(rewiredPlayer, true);
                    return null;
                case "invert_aim":
                    InvertAxis(rewiredPlayer, true);
                    return null;
                default:
                    return EffectResponse.Failure(request.ID, StandardErrors.EffectUnknown);
            }
        }

        public override EffectResponse Stop(EffectRequest request)
        {
            PlayerController player = Manager.main.player;
            if (player == null) return EffectResponse.Failure(request.ID, StandardErrors.PlayerNotFound);

            PlayerInput input = player.inputModule;
            if (input == null) return EffectResponse.Failure(request.ID, StandardErrors.GameObjectNotFound, "Player input module not found.");

            Player rewiredPlayer = input.rewiredPlayer;
            if (rewiredPlayer == null) return EffectResponse.Failure(request.ID, StandardErrors.GameObjectNotFound, "Rewired player object not found.");
            
            switch (request.code)
            {
                case "invert_movement":
                    InvertAxis(rewiredPlayer, false);
                    return null;
                case "invert_aim":
                    InvertAxis(rewiredPlayer, false);
                    return null;
                default:
                    return EffectResponse.Failure(request.ID, StandardErrors.EffectUnknown);
            }
        }
    }
}